unit Drukowanie;

interface

uses Classes,Graphics,Dialogs,SysUtils,Types,Printers;

function Drukuj(tekst :TStrings;czcionka :TFont;domyslnaDrukarka :Boolean) :Integer; overload;
procedure Drukuj(obraz :TGraphic;zachowajProporcje,domyslnaDrukarka :Boolean); overload;
procedure DrukujTekstowo(tekst :TStrings);

implementation

function Drukuj(tekst :TStrings;czcionka :TFont;domyslnaDrukarka :Boolean) :Integer;
const
  marginesLewy=1000;
  marginesPrawy=1000;
  marginesGorny=1000;
  marginesDolny=1000;
var
  i,linia :Integer;
  wysokoscCzcionki,wysokoscLinii,szerokoscStrony :Integer;
  PrintDialog :TPrintDialog;
begin
Result:=0;

if not domyslnaDrukarka then
  begin
  PrintDialog:=TPrintDialog.Create(nil);
  if not PrintDialog.Execute then Exit;
  end;

//Ustawianie wielkosci czcionki
Printer.Canvas.Font:=czcionka;

//Ustalanie wysokosci wiersza na wydruku na podstawie wielkosci czcionki
wysokoscCzcionki:=Printer.Canvas.TextHeight('A');
for i:=0 to tekst.Count-1 do
  if Printer.Canvas.TextHeight(tekst.Strings[i])>wysokoscCzcionki then
    wysokoscCzcionki:=Printer.Canvas.TextHeight(tekst.Strings[i]);

//Wysokosc linii to poltora wysokosci najwyzszej czcionki
wysokoscLinii:=(3*wysokoscCzcionki) div 2;

//ustalanie koloru tekstu
Printer.Canvas.Pen.Color:=czcionka.Color;

//lamanie dlugich linii
szerokoscStrony:=Printer.PageWidth-marginesLewy-marginesPrawy;
for i:=0 to tekst.Count-1 do
  if Printer.Canvas.TextWidth(tekst.Strings[i])>szerokoscStrony then
    ShowMessage('Linia '+IntToStr(i)+' jest dusza ni szeroko strony');

Printer.BeginDoc;
linia:=0;
Result:=1;
for i:=0 to tekst.Count-1 do
  begin
  Printer.Canvas.TextOut(marginesLewy,marginesGorny+linia*wysokoscLinii,tekst.Strings[i]);
  Inc(linia);
  if (marginesGorny+linia*wysokoscLinii)>=(Printer.PageHeight-marginesDolny) then
    begin
    linia:=0;
    Printer.NewPage;
    Inc(Result);
    end;
  end;
Printer.EndDoc;
end;

procedure Drukuj(obraz :TGraphic;zachowajProporcje,domyslnaDrukarka :Boolean);
const
  marginesLewy=1000;
  marginesPrawy=1000;
  marginesGorny=1000;
  marginesDolny=1000;
var
  PrintDialog :TPrintDialog;
  obszar :TRect;
  punkt :TPoint;
  proporcjeObrazu,proporcjeObszaru :Real;
begin
if not domyslnaDrukarka then
  begin
  PrintDialog:=TPrintDialog.Create(nil);
  if not PrintDialog.Execute then Exit;
  end;

proporcjeObrazu:=obraz.Width/obraz.Height;

//wstepny obszar to cala strona poza marginesami
obszar.Left:=marginesLewy;
obszar.Right:=Printer.PageWidth-marginesPrawy;
obszar.Top:=marginesGorny;
obszar.Bottom:=Printer.PageHeight-marginesDolny;
proporcjeObszaru:=(obszar.Right-obszar.Left)/(obszar.Bottom-obszar.Top);

//skalowanie
if zachowajProporcje then
  begin
  if (proporcjeObrazu>proporcjeObszaru) then
    obszar.Bottom:=obszar.Top+Round((obszar.Right-obszar.Left)/proporcjeObrazu)
    else
    obszar.Right:=obszar.Left+Round((obszar.Bottom-obszar.Top)*proporcjeObrazu);
  end;

//drukowanie
Printer.BeginDoc;
Printer.Canvas.TextOut(0,0,''); //wymuszenie przygotowania plotna
Printer.Canvas.StretchDraw(obszar,obraz);
Printer.EndDoc;
end;

procedure DrukujTekstowo(tekst :TStrings);
var
  PrintDialog :TPrintDialog;
  i :Integer;
  f :TextFile;
begin
//AssignPrn(f); //drukowanie w trybie graficznym
AssignFile(f,'LPT1'); //drukowanie w trybie tekstowym
Rewrite(f);

for i:=0 to tekst.Count-1 do
  writeln(f,tekst.Strings[i]);

CloseFile(f);
end;

end.
